﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserLogin.aspx.cs" Inherits="ccPublisherWeb.UserLogin" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title>User Login</title>
   
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="RegisterLogin.css" runat="server" />

   <script language="javascript" type="text/javascript">
      function login() {
         if(formValidator.Validate()) {
            setTimeout(function() {
               <%# ModalProgressID %>.Show();
               <%# Page.ClientScript.GetPostBackEventReference(btSubmit, "") %>;
            }, 0);
         }
      }

      function loginSuccess(mainRedir, showModal, toTop) {
         setTimeout(function() {
            if(showModal) {
               <%# ModalProgressID %>.Show();
            }

            if(toTop)
            {
                window.top.location.href = mainRedir;
            }
            else
            {
                <%-- Reload top frame --%>
                if(window.top && window.top.title)
                {
                   window.top.title.location.href = window.top.title.location.href;
                }

                <%-- Reload menu frame --%>
                if(window.top && window.top.menu)
                {
                   var menuFrameURL = window.top.menu.location.href;

                    if(menuFrameURL.indexOf("#") > -1)
                    {
                        menuFrameURL = menuFrameURL.substring(0, menuFrameURL.indexOf("#"));
                    }

                    window.top.menu.location.href = menuFrameURL;
                }

                window.location.href = mainRedir;
            }
         }, 0);
      }
   </script>
</head>
<body>
   <script language="javascript" type="text/javascript" src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.JS.wz_tooltip.js"></script>
   
   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_Main" runat="server">
         <div id="LoginPage">
            <div id="LoginBox">
               <h1><%# ccPublisherWeb.TextDic.TxGet("Text_Login")%></h1>
         
               <div id="InnerBorder">
                  <table id="LoginTable" border="0" cellpadding="2" cellspacing="1">
                     <tbody>
                        <tr>
                           <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_CustomerEMail") %></td>
                           <td class="Value">
                              <asp:TextBox ID="txEmail" runat="server" />
                           </td>
                        </tr>
                        <tr>
                           <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_Password") %></td>
                           <td class="Value">
                              <asp:TextBox ID="txPassword" TextMode="Password" runat="server" />
                           </td>
                        </tr>
                        <tr>
                           <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_CookieInfo")%></td>
                           <td class="Value">
                              <input id="ckCookieLogin" type="checkbox" class="Checkbox" runat="server" />
                           </td>
                        </tr>
                        <tr id="Placeholder_LoginError" runat="server">
                           <td colspan="2">
                              <asp:Label ID="lbLoginErrorMessage" CssClass="ErrorMessage" runat="server"></asp:Label>
                              <asp:PlaceHolder ID="Placeholder_PasswordLostLink" runat="server">
                                 <br />
                                 <a href="RequestPassword.aspx" class="LkPasswordLost"><%# ccPublisherWeb.TextDic.TxGet("Text_LoginWrongLoginData_PasswordLostLinkText") %></a>
                              </asp:PlaceHolder>
                           </td>
                        </tr>
                     </tbody>
                  </table>
            
                  <div class="Paragraph">
                     <%# string.Format(ccPublisherWeb.TextDic.TxGet("Text_LoginRegNote"), ccPublisherWeb.CustomApplicationHooks.Factory.UserLogin_RegisterLink) %>
                  </div>
            
                  <div id="Buttons">
                     <input type="button" value="Login" onclick="login()" />
                  </div>
               </div>
         
               <div style="display: none">
                  <asp:Button ID="btSubmit" OnClick="Login" runat="server" />
               </div>
            </div>

            <p>&nbsp;</p>
      
            <p id="Footer">
               <%# ccPublisherWeb.TextDic.TxGet("Text_Copy_Rechte") %>
            </p>
         </div>
   
         <script language="javascript" type="text/javascript">
            $(function() {
               formValidator = new FieldValidator();
               formValidator.SetOnOkFunction(function() { login(); });

               formValidator.Add(new ValidationEvent(
                  $("#<%# txEmail.ClientID %>"),
                  function(sender) {
                     return ccPublisherWeb.CheckEmail(sender.val());
                  }
               ));
         
               formValidator.Add(new ValidationEvent(
                  $("#<%# txPassword.ClientID %>"),
                  function(sender) {
                     var value = String.trim(sender.val());
                     return (value != "");
                  }
               ));

               $("A[href='RegForm.aspx']").click(function() {
                  $("HTML").css("overflow", "hidden");
                  $("BODY").css("overflow", "hidden");
                  $("FORM").css("overflow", "hidden");
                  <%# ModalProgressID %>.Show();
               });

               <%-- Set focus on username/email field --%>
               setTimeout(function() {
                  $("#<%# txEmail.ClientID %>").focus();
               }, 300);

               if($("#<%# Placeholder_LoginError.ClientID %>").length) {
                  $("#<%# txEmail.ClientID %>, #<%# txPassword.ClientID %>").keydown(function() {
                     $("#<%# Placeholder_LoginError.ClientID %>").hide();
                  });
               }

               <asp:Literal ID="litShowErrorMessage" Visible="false" runat="server" />
            });


            function showError(errorText) {
               <%# MessageBoxID %>.Show({
                  title: "<%# ccPublisherWeb.TextDic.TxGet("Text_UserLogin_Error_Title") %>",
                  messageText: errorText,
                  width: 400,
                  minHeight: 80,
                  icon: MessageBox.Constants.MB_ICON_ERROR,
                  buttons: MessageBox.Constants.MB_OK
               });
            }
         </script>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Maintenance" Visible="false" runat="server">
         <div class="MaintenanceMode">
            <%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_DisabledMaintenance") %>
         </div>
      </asp:PlaceHolder>
   </form>
   
   <asp:PlaceHolder ID="Placeholder_ExtFormLogin" Visible="false" runat="server">
      <iframe id="CrossDomainFrame" src="about:blank" frameborder="0" width="0" height="0"></iframe>
   </asp:PlaceHolder>

   <asp:PlaceHolder ID="Placeholder_LoginOkScript" Visible="false" runat="server">
      <script language="javascript" type="text/javascript">
         function loginSuccessCallback() {
            <%# LoginSuccessCallbackFunction %>
         }

         $(function() {
            if($("#CrossDomainFrame").length) {
               $("#CrossDomainFrame")
                  .attr("src", "<%# ExtLoginFrameUrl %>")
                  .load(function() {
                     loginSuccessCallback();
                  });
            } else {
               loginSuccessCallback();
            }
         });
      </script>
   </asp:PlaceHolder>
</body>
</html>
